# 제품 요구사항 문서 (PRD)

## 1. 총괄 요약
작업자가 회사명과 설비명 또는 시리얼넘버를 입력하면, 사전에 관리되는 CSV 데이터베이스를 기반으로 회사명, 설비명, 시리얼넘버, 제작일, 모델명, 스핀들시리얼넘버를 즉시 조회·출력하고, 확인된 정보를 지정된 엑셀 템플릿(xlsx)에 자동 업데이트하여 여러 보고서를 빠르게 생성하는 데스크탑 애플리케이션이다. 오프라인 캐시 및 온라인 실시간 동기화를 모두 지원하여 보고서 작성 시간을 대폭 단축한다.

## 2. 문제 정의
- 수작업으로 설비 정보를 검색·전사·작성하는 과정이 길고 오류가 잦다.  
- 현장 네트워크 환경이 불안정해 오프라인에서도 데이터 조회가 필요하다.  
- 동일 정보로 여러 형식의 보고서를 반복 작성해야 해 비효율적이다.  

## 3. 목표 및 지표
- 1차 목표: 설비 정보 조회·보고서 생성 시간을 70% 이상 단축  
- 2차 목표: 데이터 입력 오류율 90% 감소, 사용자 만족도(NPS) +40 달성  
- 성공 지표  
  - 평균 보고서 작성 소요 시간 ≤ 2분  
  - 조회 정확도 ≥ 99%  
  - 월간 활성 사용자 수(MAU) 200명 달성  

## 4. 대상 사용자
### 주요 사용자
- 제조 현장 작업자 및 엔지니어  
  - 현장 단말(노트북/산업용 PC) 사용  
  - 빠른 조회와 간단한 조작 선호  
### 이해관계자
- 품질·생산 관리팀: 일관된 보고서 형식 확보  
- IT 팀: 데이터 관리 및 배포  

## 5. 사용자 스토리
- “작업자로서 회사명+설비명만 입력해도 모든 설비 세부정보를 확인해 즉시 보고서를 만들고 싶다.”  
- “네트워크가 없을 때도 미리 저장된 데이터로 동일한 기능을 사용하고 싶다.”  
- “한 번의 입력으로 같은 회사의 여러 설비 보고서를 일괄 생성하고 싶다.”  
- “정보가 누락되거나 불일치할 때 경고를 받고 신뢰성을 확보하고 싶다.”  

## 6. 기능 요구사항
### 핵심 기능
1. 설비 정보 조회  
   - 입력: `회사명+설비명` 또는 `회사명+시리얼넘버`  
   - 처리: 로컬 캐시 우선, 미존재 시 서버 CSV 요청  
   - 출력: 회사명, 설비명, 시리얼넘버, 제작일, 모델명, 스핀들시리얼넘버  
   - 수용 기준  
     - 평균 조회 시간 ≤ 1초  
     - 필드 누락 시 “데이터 없음” 메시지 표시  

2. 데이터 동기화  
   - 앱 실행 시 서버의 최신 CSV 자동 다운로드 및 로컬 캐시 갱신  
   - 오프라인 모드 시 마지막 동기화 데이터 사용  
   - 수용 기준  
     - 동기화 후 데이터 일치율 100%  
     - 네트워크 오류 시 재시도 및 사용자 알림  

3. 엑셀 보고서 자동 작성  
   - 개발자 제공 xlsx 템플릿 로드  
   - 사용자 확인(Yes/No) 후 각 필드를 지정 셀에 매핑  
   - 동시에 복수 템플릿 파일 생성 가능(`설비명_날짜.xlsx`)  
   - 수용 기준  
     - 생성 성공률 99% 이상  
     - 파일명 규칙 및 저장 경로 설정 가능  

4. 다중 설비 일괄 처리  
   - 하나의 회사에 대해 여러 설비를 선택·추가하여 한 번에 보고서 생성  
   - 진행률 표시 및 완료 알림 제공  

### 지원 기능
- 입력 자동완성(회사명·설비명 검색 제안)  
- 데이터 유효성 검증 및 중복 경고  
- 로그·이력 관리(조회·작성 내역)  
- 다국어 인터페이스(한국어/영어)  

### Nice-to-Have 제안
- QR/바코드 리더 연동으로 시리얼넘버 자동 입력  
- 관리자용 CSV 편집 UI  
- 자동 업데이트 알림 및 강제 배포 기능  

## 7. 비기능 요구사항
- 성능: 10만 행 CSV 기준 조회 1초 이내  
- 보안: 로컬 데이터 암호화(AES256), TLS 통신  
- 사용성: 키보드 중심 인터페이스, 접근성 가이드 준수  
- 확장성: CSV → RDB 전환 용이한 DAO 구조  
- 호환성: Windows 10 이상, .xlsx 2007+ 호환  

## 8. 기술 고려사항
- 아키텍처: Python(PySide6) 데스크탑 + SQLite 캐시 + REST API  
- 데이터: `company_equipment.csv`(UTF-8, S3 저장) → 주기적 버저닝  
- 패키징: PyInstaller 실행파일, 자동 업데이트 모듈 포함  
- 타사 의존성: pandas(openpyxl), requests, tqdm  
- 향후 확장: Electron 또는 .NET MAUI 전환 검토  

## 9. 성공 지표
- 기능: 조회 정확도, 보고서 생성 성공률  
- 비즈니스: 보고서 작성 시간, 오류 재작업 건수  
- 기술: 동기화 실패율, 앱 크래시율  

## 10. 일정 및 마일스톤
- 1단계(M1, 4주): 핵심 조회 엔진, 로컬 캐시, CLI 프로토타입  
- 2단계(M2, 8주): GUI, 엑셀 템플릿 연동, 오프라인 지원, 내부 베타  
- 3단계(M3, 4주): 다중 설비 처리, 자동완성, 공개 베타  
- 4단계(릴리스, 2주): 안정화, 배포 자동화, 사용자 교육 자료 배포  

## 11. 위험 및 대응
- CSV 충돌·포맷 변경 → 스키마 검증 스크립트, 버전 관리  
- 네트워크 불안정 → 오프라인 캐시, 재시도 로직  
- 사용자 입력 오류 → 자동완성·검증·실시간 경고  
- 지속 유지보수 인력 부족 → 코드 문서화, 테스트 자동화  

## 12. 향후 과제
- 클라우드 DB 이전 및 실시간 변경 반영  
- 모바일 앱(Flutter) 확장  
- AI 기반 설비 정보 예측·보완 기능  
- 보고서 서식 커스터마이저 및 워크플로 자동화  

