#!/usr/bin/env python3
# -*- coding: utf-8 -*-
"""
N1VI - 설비 정보 조회 및 보고서 생성 애플리케이션

이 패키지는 회사명+(설비명 또는 시리얼넘버) 입력을 받아 
설비 정보를 조회하고 Excel 보고서를 생성하는 데스크탑 애플리케이션입니다.

주요 기능:
- 설비 정보 조회 (CSV 기반)
- 오프라인 캐시 지원
- Excel 보고서 자동 생성
- 다중 설비 일괄 처리
"""

__version__ = "1.0.0"
__author__ = "N1VI Development Team"
__email__ = "dev@n1vi.com"
__description__ = "설비 정보 조회 및 보고서 생성 애플리케이션"

# 패키지 레벨 상수
APP_NAME = "N1VI"
APP_VERSION = __version__
DEFAULT_DATA_FILE = "company_equipment.csv"
DEFAULT_CACHE_DB = "n1vi_cache.sqlite"
DEFAULT_CONFIG_FILE = "n1vi_config.json"

# 로깅 설정
import logging
import os
from pathlib import Path

# 로그 디렉토리 생성
LOG_DIR = Path("logs")
LOG_DIR.mkdir(exist_ok=True)

# 기본 로거 설정
logging.basicConfig(
    level=logging.INFO,
    format='%(asctime)s - %(name)s - %(levelname)s - %(message)s',
    handlers=[
        logging.FileHandler(LOG_DIR / "n1vi.log", encoding='utf-8'),
        logging.StreamHandler()
    ]
)

logger = logging.getLogger(__name__)
logger.info(f"N1VI {__version__} 패키지 초기화 완료")

# 서브 패키지 노출
from . import database
from . import models
from . import services
from . import ui
from . import utils

__all__ = [
    "database",
    "models", 
    "services",
    "ui",
    "utils",
    "APP_NAME",
    "APP_VERSION",
    "DEFAULT_DATA_FILE",
    "DEFAULT_CACHE_DB",
    "DEFAULT_CONFIG_FILE",
    "logger"
] 