# N1VI 프로젝트 - 기술 스택 선택기

## 📋 프로젝트 개요
N1VI 프로젝트는 설비 정보 조회 및 보고서 생성을 위한 데스크탑 애플리케이션입니다.
이 선택기는 개발자가 프로젝트에 사용할 기술 스택을 선택할 수 있도록 도와줍니다.

## 🚀 실행 방법

### 1. 필요한 패키지 설치
```bash
pip install PySide6
```

### 2. 기술 스택 선택 UI 실행
```bash
python tech_stack_selector.py
```

### 3. 기술 스택 선택
- **Python (PySide6)** [권장]: 데스크탑 네이티브 애플리케이션
- **Electron**: 웹 기술 기반 데스크탑 애플리케이션
- **.NET MAUI**: 마이크로소프트 크로스 플랫폼 framework

## 📊 기술 스택 비교

### Python (PySide6) [권장]
✅ **장점**
- 빠른 개발 속도 및 풍부한 라이브러리 생태계
- pandas, openpyxl 등 데이터 처리에 최적화
- 네이티브 성능과 시스템 리소스 효율성
- 단일 실행 파일로 배포 가능 (PyInstaller)
- 오프라인 환경에서 완벽한 동작

⚠️ **단점**
- UI 디자인의 제한적 유연성
- 웹 기반 UI 대비 현대적 디자인 어려움
- 크로스 플랫폼 배포 시 테스트 필요

### Electron
✅ **장점**
- 웹 기술 사용으로 현대적이고 유연한 UI
- 빠른 프로토타이핑과 반응형 디자인
- 풍부한 웹 라이브러리 활용 가능
- 크로스 플랫폼 지원 우수

⚠️ **단점**
- 높은 메모리 사용량 (Chrome 기반)
- 상대적으로 느린 시작 속도
- 네이티브 앱 대비 큰 설치 파일 크기
- Python 데이터 처리 라이브러리 연동 복잡

### .NET MAUI
✅ **장점**
- 뛰어난 성능과 네이티브 사용자 경험
- Microsoft 생태계와의 완벽한 통합
- 강력한 타입 시스템과 개발 도구
- 엔터프라이즈 환경에서 안정적

⚠️ **단점**
- 상대적으로 높은 학습 곡선
- Python 데이터 처리 라이브러리 대체 필요
- 라이센스 비용 (Visual Studio)
- macOS/Linux 개발 환경 제한

## 📁 생성된 파일

### `tech_stack_selection.json`
선택된 기술 스택 정보가 저장됩니다.
```json
{
  "selected_stack": "Python (PySide6)",
  "timestamp": "2025-07-08T20:14:09.925273",
  "tech_details": "PySide6 + SQLite + pandas + openpyxl + requests",
  "description": "Python 기반 데스크탑 애플리케이션으로 빠른 개발과 안정성을 제공합니다."
}
```

## 🔧 다음 단계 (Python 선택 시)

1. **필요한 Python 패키지 설치**
   ```bash
   pip install -r requirements.txt
   ```

2. **기본 프로젝트 구조 생성**
   - 데이터베이스 모델 설계
   - 비즈니스 로직 레이어
   - UI 컴포넌트 구조

3. **핵심 기능 구현**
   - CSV 데이터 처리 모듈
   - 설비 정보 조회 엔진
   - 엑셀 보고서 생성 기능

4. **UI 개발**
   - PySide6 기반 메인 윈도우
   - 검색 및 입력 폼
   - 결과 출력 및 보고서 생성 UI

5. **배포 준비**
   - PyInstaller를 통한 실행 파일 생성
   - 설치 프로그램 생성

## 📝 참고사항
- 개발자 확인이 필요하므로 선택 후 다음 작업은 자동으로 진행되지 않습니다.
- 선택된 기술 스택에 따라 프로젝트 구조와 개발 방식이 달라집니다.
- 각 기술 스택의 특성을 고려하여 신중히 선택해주세요.

## 🎯 프로젝트 목표
- 설비 정보 조회·보고서 생성 시간 70% 이상 단축
- 데이터 입력 오류율 90% 감소
- 평균 보고서 작성 소요 시간 ≤ 2분 