# N1VI 프로젝트 구조

## 📁 디렉토리 구조

```
N1VI/
├── 📁 src/                     # 소스 코드
│   └── 📁 n1vi/               # 메인 애플리케이션 패키지
│       ├── 📄 __init__.py     # 패키지 초기화
│       ├── 📁 database/       # 데이터베이스 관련
│       ├── 📁 models/         # 데이터 모델
│       ├── 📁 services/       # 비즈니스 로직
│       ├── 📁 ui/            # 사용자 인터페이스
│       └── 📁 utils/         # 공통 유틸리티
├── 📁 data/                   # 데이터 파일
├── 📁 templates/              # Excel 템플릿
├── 📁 docs/                   # 문서
├── 📁 tests/                  # 테스트 코드
├── 📁 build/                  # 빌드 파일
├── 📁 logs/                   # 로그 파일
├── 📁 output/                 # 출력 파일
├── 📁 backup/                 # 백업 파일
├── 📄 main.py                 # 메인 애플리케이션
├── 📄 config.py               # 설정 관리
├── 📄 run.py                  # 개발 실행 스크립트
├── 📄 build.py                # 빌드 스크립트
├── 📄 requirements.txt        # 의존성 목록
├── 📄 README.md               # 프로젝트 설명
├── 📄 PROJECT_STRUCTURE.md    # 이 파일
└── 📄 n1vi_config.json        # 런타임 설정
```

## 🔧 핵심 파일 설명

### 📄 main.py
- 애플리케이션의 메인 진입점
- PySide6 기반 GUI 애플리케이션
- 기본 테스트 기능 포함

### 📄 config.py
- 전역 설정 관리
- JSON 기반 설정 파일 처리
- 환경 변수 지원

### 📄 run.py
- 개발 환경 실행 스크립트
- 의존성 검사 및 환경 설정
- 개발 모드 지원

### 📄 build.py
- PyInstaller 기반 빌드 스크립트
- 실행 파일 생성
- 배포 패키지 생성

## 📦 설치된 의존성

```txt
PySide6==6.6.1          # GUI 프레임워크
pandas==2.1.4           # 데이터 처리
openpyxl==3.1.2         # Excel 파일 처리
requests==2.31.0        # HTTP 통신
tqdm==4.66.1            # 진행률 표시
PyInstaller==5.13.2     # 실행 파일 빌드
cryptography==41.0.7    # 암호화
```

## 🚀 실행 방법

### 개발 모드
```bash
python run.py
```

### 직접 실행
```bash
python main.py
```

### 빌드
```bash
python build.py
```

## ✅ 테스트 결과

애플리케이션이 정상적으로 실행되었습니다:

```
==================================================
🎯 N1VI 개발 환경 실행기
==================================================
🔍 의존성 검사 중...
  ✅ PySide6
  ✅ pandas
  ✅ openpyxl
  ✅ requests
  ✅ tqdm
✅ 모든 의존성 확인 완료!
⚙️  개발 환경 설정 중...
✅ 환경 설정 완료!
🚀 N1VI 애플리케이션 실행 중...
✅ 애플리케이션이 정상적으로 종료되었습니다.
```

## 🎯 다음 단계

1. **데이터베이스 모듈 구현** (src/n1vi/database/)
   - SQLite 캐시 시스템
   - CSV 데이터 처리
   - 데이터 동기화

2. **데이터 모델 정의** (src/n1vi/models/)
   - 설비 정보 모델
   - 설정 모델
   - 검증 로직

3. **비즈니스 로직 구현** (src/n1vi/services/)
   - 설비 조회 서비스
   - Excel 보고서 생성
   - 외부 API 통신

4. **UI 컴포넌트 개발** (src/n1vi/ui/)
   - 메인 윈도우
   - 검색 폼
   - 결과 표시

5. **유틸리티 함수** (src/n1vi/utils/)
   - 파일 처리
   - 데이터 변환
   - 로깅 헬퍼

## 📝 설정 파일

### n1vi_config.json
자동 생성되는 설정 파일로 다음 항목들을 포함합니다:

- **app**: 애플리케이션 기본 설정
- **database**: 데이터베이스 및 캐시 설정  
- **api**: 외부 API 통신 설정
- **excel**: Excel 보고서 설정
- **ui**: 사용자 인터페이스 설정
- **logging**: 로깅 설정
- **security**: 보안 관련 설정

## 🔒 보안

- SQLite 캐시 암호화 지원
- HTTPS 통신 강제
- 설정 파일 검증

## 📊 로깅

- 자동 로그 디렉토리 생성 (logs/)
- 파일 및 콘솔 출력
- 로그 로테이션 지원

이제 기본 프로젝트 구조가 완성되었습니다! 🎉 